const app = require('../app');
const error = require('../error');
const router = require('../router');
const loader = require('../views/loader');
// eslint-disable-next-line no-unused-vars
const Layout = require('../views/layouts/BasicLayout');
const LayoutConfig = require('../application/config/layoutConfig');
const resources = require('../resources');
const BasicLayout = require('../collection/BasicCollection');
// eslint-disable-next-line no-unused-vars
const ClientModel = require('../model/clients/ClientModel');
const rum = require('../helpers/utils/rum');

router.on('route:hostQueue', function (hostId) {
    /* eslint max-statements: [1, 18] */

    rum.setPage('unknown');

    app.performance.epoch = window.performance.now();
    app.performance.internalRoute = 'route:hostQueue';
    app.trigger('trigger:route:change', app.performance.internalRoute);

    document.title = ('Host ' + hostId + ' queue | Sandbox');

    this.unbindRouteRelatedEvents();

    loader.show();

    const appRouter = this;
    const pageProps = router.parseQueryString(window.location.search);
    const resourceLocator = this.getResourceLocator();

    resourceLocator.setPageProps(LayoutConfig.getPageConfig('HOST_QUEUE'));

    this.showBasicLayout(resourceLocator);

    resources
        .enqueuedTasks({
            user: {},
            enqueued: _.extend(
                {},
                BasicLayout.parsePagingProps(pageProps),
                { client: hostId }
            )
        }, resourceLocator)
        .done(() => {
            appRouter.showContentLayout();
            loader.hide();
        })
        .fail((err, name, description) => {
            appRouter.showErrorPage(err, name, description);
            error.fromXHR({ xhr: err, name, description });
        });

    app.initMetric();
});
