// eslint-disable-next-line no-unused-vars
const Layout = require('../views/layouts/BasicLayout');
const LayoutConfig = require('../application/config/layoutConfig');
// eslint-disable-next-line no-unused-vars
const CoreApplication = require('../application/CoreApplication');
const app = require('../app');
const router = require('../router');
const loader = require('../views/loader');
const resources = require('../resources');
const error = require('../error');
const rum = require('../helpers/utils/rum');

router.on('route:notFound', function () {
    /* eslint max-statements: [1, 13] */

    rum.setPage('unknown');

    app.performance.epoch = window.performance.now();
    app.performance.internalRoute = 'route:notFound';
    app.trigger('trigger:route:change', app.performance.internalRoute);

    document.title = ('PAGE NOT FOUND | Sandbox');

    this.unbindRouteRelatedEvents();

    loader.show();

    const appRouter = this;
    const resourceLocator = this.getResourceLocator();

    resourceLocator.setPageProps(LayoutConfig.getPageConfig('ERROR'));

    resources
        .user({}, resourceLocator)
        .done(user => {
            resourceLocator.set({ user });

            appRouter.showContentLayout();
            loader.hide();
        })
        .fail((err, name, description) => {
            appRouter.showErrorPage(err, name, description);
            error.fromXHR({ xhr: err, name, description });
        });

    app.initMetric();
});
