const app = require('../app');
const error = require('../error');
const router = require('../router');
const loader = require('../views/loader');
// eslint-disable-next-line no-unused-vars
const Layout = require('../views/layouts/BasicLayout');
const LayoutConfig = require('../application/config/layoutConfig');
const resources = require('../resources');
// eslint-disable-next-line no-unused-vars
const CoreApplication = require('../application/CoreApplication');
const rum = require('../helpers/utils/rum');

router.on('route:oauth', function (action) {
    /* eslint max-statements: [1, 16] */

    rum.setPage('oauth');

    app.performance.epoch = window.performance.now();
    app.performance.internalRoute = 'route:oauth';
    app.trigger('trigger:route:change', app.performance.internalRoute);

    document.title = ('OAuth token | Sandbox');

    this.unbindRouteRelatedEvents();

    loader.show();

    if (action) {
        const appRouter = this;
        const resourceLocator = this.getResourceLocator();

        resourceLocator.setPageProps(LayoutConfig.getPageConfig('OAUTH'));

        this.showBasicLayout(resourceLocator);

        $.when(resources.user({}, resourceLocator), resources.taskProps({}, resourceLocator))
            .done((/* user, taskProps */) => {
                appRouter.showContentLayout();

                loader.hide();
            })
            .fail((err, name, description) => {
                appRouter.showErrorPage(err, name, description);
                error.fromXHR({ xhr: err, name, description });
            });

        app.initMetric();
    } else {
        $.ajax({
            url: '/api/v1.0/authenticate/oauth/client',
            type: 'GET',
            dataType: 'json',
            contentType: 'application/json'
        }).done(responseData => {
            window.location.href = (
                responseData.url + 'authorize?' +
                'response_type=token&' +
                'client_id=' + responseData.client
            );
        })
            .fail(xhr => {
                app.reqres.request('ERR_TRACE', xhr);
                error.showErrPage(xhr);
            });
    }
});
