const app = require('../app');
const router = require('../router');
const loader = require('../views/loader');
const LayoutConfig = require('../application/config/layoutConfig');
const rum = require('../helpers/utils/rum');

router.on('route:preferences', function () {
    /* eslint max-statements: [1, 14] */

    rum.setPage('preferences');

    app.performance.epoch = window.performance.now();
    app.performance.internalRoute = 'route:preferences';
    app.trigger('trigger:route:change', app.performance.internalRoute);

    document.title = ('Preferences | Sandbox');

    this.unbindRouteRelatedEvents();

    loader.show();

    const resourceLocator = this.getResourceLocator();

    resourceLocator.setPageProps(LayoutConfig.getPageConfig('PREFERENCES'));

    this.showBasicLayout(resourceLocator);
    this.showContentLayout();

    loader.hide();

    app.initMetric();
});
