// eslint-disable-next-line no-unused-vars
const Layout = require('../views/layouts/BasicLayout');
const LayoutConfig = require('../application/config/layoutConfig');
const app = require('../app');
const router = require('../router');
const loader = require('../views/loader');
const resources = require('../resources');
const error = require('../error');
const rum = require('../helpers/utils/rum');

router.on('route:releases', function () {
    /* eslint max-statements: [1, 13] */

    rum.setPage('releases');

    app.performance.epoch = window.performance.now();
    app.performance.internalRoute = 'route:releases';
    app.trigger('trigger:route:change', app.performance.internalRoute);

    document.title = 'Releases | Sandbox';

    this.unbindRouteRelatedEvents();

    loader.show();

    const appRouter = this;
    const resourceLocator = this.getResourceLocator();

    resourceLocator.setPageProps(LayoutConfig.getPageConfig('RELEASE_LIST'));

    this.showBasicLayout(resourceLocator);

    resources
        .userLastFilter({
            filterModel: require('../model/filter/ReleaseFilterModel')
        })
        .done(defaultFilter => {
            app.setDefaultFilter(defaultFilter);

            $.when(resources.taskProps({}, resourceLocator)).done(taskProps => {
                resourceLocator.setProps(Object.assign({}, taskProps));

                appRouter.showFilterLayout();
            });

            resources
                .releasesList({
                    user: {},
                    releases: _.extend({}, { order: '-release__creation_time' }, defaultFilter.getFilterParams())
                }, resourceLocator)
                .done(appResources => {
                    appRouter.bindRouteRelatedEvents('releases', appResources);
                    appRouter.showContentLayout();
                    appResources.getReleases().trigger('filterChanged', appResources.getReleases());

                    loader.hide();
                })
                .fail((err, name, description) => {
                    appRouter.showErrorPage(err, name, description);
                    error.fromXHR({ xhr: err, name, description });
                });

            app.initMetric();
        })
        .fail((err, name, description) => {
            appRouter.showErrorPage(err, name, description);
            error.fromXHR({ xhr: err, name, description });
        });
});
