// eslint-disable-next-line no-unused-vars
const Layout = require('../views/layouts/BasicLayout');
const app = require('../app');
const router = require('../router');
const loader = require('../views/loader');
const resources = require('../resources/index');
const error = require('../error');
const rum = require('../helpers/utils/rum');

router.on('route:resource', function (id, action) {
    /* eslint max-statements: [1, 14] */

    rum.setPage('resource');

    app.performance.epoch = window.performance.now();
    app.performance.internalRoute = 'route:resource';
    app.trigger('trigger:route:change', app.performance.internalRoute);

    document.title = ('Resource view | Sandbox');

    this.unbindRouteRelatedEvents('resource');
    this.showBasicLayout();

    loader.show();

    const self = this;
    const resourceLocator = this.getResourceLocator();

    resourceLocator.setPageProps(this.getLayoutConfig('SINGLE_RESOURCE', {
        action: action || 'view'
    }));

    resources
        .resource({
            user: {
                presets: {
                    url: '/api/v1.0/user/current/preferences/resource-list',
                    model: require('../model/filter/ResourceFilterModel')
                }
            },
            resource: { id }
        }, resourceLocator)
        .done(appResources => {
            router.bindRouteRelatedEvents('resource', appResources);
            self.showContentLayout();

            loader.hide();
        })
        .fail(xhr => {
            app.reqres.request('ERR_TRACE', xhr);
            error.showErrPage(xhr);
        });

    app.initMetric();
});
