const LayoutConfig = require('../application/config/layoutConfig');
const app = require('../app');
const router = require('../router');
const loader = require('../views/loader');
const resources = require('../resources/index');
const error = require('../error');
const rum = require('../helpers/utils/rum');

router.on('route:resourceCreate', function () {
    rum.setPage('resource');

    app.performance.epoch = window.performance.now();
    app.performance.internalRoute = 'route:resourceCreate';
    app.trigger('trigger:route:change', app.performance.internalRoute);

    this.unbindRouteRelatedEvents();

    loader.show();

    const appRouter = this;
    const resourceLocator = this.getResourceLocator();

    resourceLocator.setPageProps(LayoutConfig.getPageConfig('CREATE_RESOURCE'));

    $.when(resources.user({}, resourceLocator), resources.resourceTypes({}, resourceLocator))
        .done((user, resourceTypes) => {
            resourceLocator.set({
                user,
                types: resourceTypes
            });

            appRouter.showContentLayout();
            loader.hide();
        })
        .fail((err, name, description) => {
            appRouter.showErrorPage(err, name, description);
            error.fromXHR({ xhr: err, name, description });
        });

    app.initMetric();
});
