// eslint-disable-next-line no-unused-vars
const Layout = require('../views/layouts/BasicLayout');
const LayoutConfig = require('../application/config/layoutConfig');
const app = require('../app');
const router = require('../router');
const loader = require('../views/loader');
const resources = require('../resources');
const error = require('../error');
const rum = require('../helpers/utils/rum');

router.on('route:resources', function () {
    /* eslint max-statements: [1, 14] */

    rum.setPage('resources');

    app.performance.epoch = window.performance.now();
    app.performance.internalRoute = 'route:resources';
    app.trigger('trigger:route:change', app.performance.internalRoute);

    const appRouter = this;
    const resourceLocator = this.getResourceLocator();

    resourceLocator.setPageProps(LayoutConfig.getPageConfig('RESOURCE_LIST'));

    document.title = ('Resources | Sandbox');

    loader.show();

    this.unbindRouteRelatedEvents();
    this.showBasicLayout();

    resources
        .userLastFilter({
            filterModel: require('../model/filter/ResourceFilterModel')
        })
        .done(defaultFilter => {
            app.setDefaultFilter(defaultFilter);

            $.when(resources.user({}, resourceLocator), resources.taskProps({}, resourceLocator))
                .done((user, taskProps) => {
                    resourceLocator.setProps(taskProps);

                    appRouter.showFilterLayout();
                })
                .fail((err, name, description) => {
                    appRouter.showErrorPage(err, name, description);
                    error.fromXHR({ xhr: err, name, description });
                });

            resources
                .resourceList({
                    user: {
                        presets: {
                            url: '/api/v1.0/user/current/preferences/resource-list',
                            model: require('../model/filter/ResourceFilterModel')
                        }
                    },
                    resources: defaultFilter.getFilterParams()
                }, appRouter.getResourceLocator())
                .done(appResources => {
                    appRouter.bindRouteRelatedEvents('resources', appResources);

                    appRouter.showContentLayout();

                    appResources.getResources().trigger('filterChanged', appResources.getResources());

                    loader.hide();
                })
                .fail((err, name, description) => {
                    appRouter.showErrorPage(err, name, description);
                    error.fromXHR({ xhr: err, name, description });
                });
        })
        .fail((err, name, description) => {
            appRouter.showErrorPage(err, name, description);
            error.fromXHR({ xhr: err, name, description });
        });

    app.initMetric();
});
