const app = require('../app');
const error = require('../error');
const router = require('../router');
const loader = require('../views/loader');
// eslint-disable-next-line no-unused-vars
const Layout = require('../views/layouts/BasicLayout');
const LayoutConfig = require('../application/config/layoutConfig');
const cookie = require('bemmy/src/blocks/component/cookie');
const resources = require('../resources');
const BasicLayout = require('../collection/BasicCollection');
const rum = require('../helpers/utils/rum');

router.on('route:sandboxNotifications', function () {
    /* eslint max-statements: [1, 15] */

    rum.setPage('notifications');

    app.performance.epoch = window.performance.now();
    app.performance.internalRoute = 'route:sandboxNotifications';
    app.trigger('trigger:route:change', app.performance.internalRoute);

    document.title = ('Notifications | Sandbox');

    this.unbindRouteRelatedEvents();

    loader.show();

    const appRouter = this;
    const pageProps = router.parseQueryString(window.location.search);
    const resourceLocator = this.getResourceLocator();

    resourceLocator.setPageProps(LayoutConfig.getPageConfig('SANDBOX_NOTIFICATIONS_LIST'));

    this.showBasicLayout(resourceLocator);

    resources
        .sandboxNotificationsList({
            user: {},
            notifications: _.extend(
                {},
                BasicLayout.parsePagingProps(pageProps),
                { filterParams: { recipient: cookie.getYandexLogin() }}
            )
        }, resourceLocator)
        .done(() => {
            appRouter.showContentLayout();

            loader.hide();
        })
        .fail((err, name, description) => {
            appRouter.showErrorPage(err, name, description);
            error.fromXHR({ xhr: err, name, description });
        });

    app.initMetric();
});
