const app = require('../app');
const error = require('../error');
const router = require('../router');
const loader = require('../views/loader');
// eslint-disable-next-line no-unused-vars
const Layout = require('../views/layouts/BasicLayout');
const resources = require('../resources');
// eslint-disable-next-line no-unused-vars
const BasicLayout = require('../collection/BasicCollection');
const rum = require('../helpers/utils/rum');

router.on('route:scheduler', function (id, action) {
    /* eslint max-statements: [1, 14] */

    rum.setPage('scheduler');

    app.performance.epoch = window.performance.now();
    app.performance.internalRoute = 'route:scheduler';
    app.trigger('trigger:route:change', app.performance.internalRoute);

    document.title = ('Scheduler #' + id + ' view | Sandbox');

    this.unbindRouteRelatedEvents('scheduler');
    this.showBasicLayout();

    const appRouter = this;
    const resourceLocator = this.getResourceLocator();

    resourceLocator.setPageProps(appRouter.getLayoutConfig('SINGLE_SCHEDULER', {
        action: (action ? action : 'view')
    }));

    loader.show();

    resources
        .scheduler({
            user: {
                presets: {
                    url: '/api/v1.0/user/current/preferences/schedulers-list',
                    model: require('../model/filter/SchedulerFilterModel')
                }
            },
            scheduler: { id }
        }, resourceLocator)
        .done(appResources => {
            appRouter.bindRouteRelatedEvents('scheduler', appResources);
            appRouter.showContentLayout();

            loader.hide();
        })
        .fail((err, name, description) => {
            appRouter.showErrorPage(err, name, description);
            error.fromXHR({ xhr: err, name, description });
        });

    app.initMetric();
});
