const LayoutConfig = require('../application/config/layoutConfig');
const app = require('../app');
const router = require('../router');
const loader = require('../views/loader');
const resources = require('../resources/index');
const error = require('../error');
const rum = require('../helpers/utils/rum');

router.on('route:schedulerCreate', function (id) {
    /* eslint max-statements: [1, 16] */

    rum.setPage('scheduler');

    app.performance.epoch = window.performance.now();
    app.performance.internalRoute = 'route:schedulerCreate';
    app.trigger('trigger:route:change', app.performance.internalRoute);

    this.unbindRouteRelatedEvents();

    loader.show();

    const appRouter = this;
    const resourceLocator = this.getResourceLocator();

    resourceLocator.setPageProps(LayoutConfig.getPageConfig('SINGLE_SCHEDULER'));

    if (!app.getDraftScheduler() && !id) {
        router.navigate('/schedulers', { trigger: true });

        return;
    }

    this.showBasicLayout();

    resources
        .schedulerCreate({ id }, this.getResourceLocator())
        .done(appResources => {
            router.navigate('/scheduler/' + appResources.getScheduler().get('id') + '/view', { replace: true });

            appRouter.showContentLayout();

            loader.hide();
        })
        .fail((err, name, description) => {
            appRouter.showErrorPage(err, name, description);
            error.fromXHR({ xhr: err, name, description });
        });

    app.initMetric();
});
