const LayoutConfig = require('../application/config/layoutConfig');
const app = require('../app');
const error = require('../error');
const router = require('../router');
const loader = require('../views/loader');
const resources = require('../resources');
const BasicLayout = require('../collection/BasicCollection');
const rum = require('../helpers/utils/rum');

router.on('route:schedulers', function () {
    /* eslint max-statements: [1, 14] */

    rum.setPage('schedulers');

    app.performance.epoch = window.performance.now();
    app.performance.internalRoute = 'route:schedulers';
    app.trigger('trigger:route:change', app.performance.internalRoute);

    document.title = ('Schedulers | Sandbox');

    this.unbindRouteRelatedEvents();

    loader.show();

    const appRouter = this;
    const resourceLocator = this.getResourceLocator();

    resourceLocator.setPageProps(LayoutConfig.getPageConfig('SCHEDULERS_LIST'));

    this.showBasicLayout(resourceLocator);

    resources
        .userLastFilter({
            filterModel: require('../model/filter/SchedulerFilterModel')
        })
        .done(defaultFilter => {
            const pageProps = router.parseQueryString(window.location.search);

            app.setDefaultFilter(defaultFilter);

            $.when(resources.user({}, resourceLocator), resources.schedulersProps({}, resourceLocator))
                .done((user, schedulersProps) => {
                    resourceLocator.setProps(schedulersProps);

                    appRouter.showFilterLayout();
                })
                .fail((err, name, description) => {
                    appRouter.showErrorPage(err, name, description);
                    error.fromXHR({ xhr: err, name, description });
                });

            resources
                .schedulersList({
                    user: {
                        presets: {
                            url: '/api/v1.0/user/current/preferences/schedulers-list',
                            model: require('../model/filter/SchedulerFilterModel')
                        }
                    },
                    schedulers: _.extend(
                        { order: '-id' },
                        BasicLayout.parsePagingProps(pageProps),
                        defaultFilter.getFilterParams()
                    )
                }, resourceLocator)
                .done(appResources => {
                    appRouter.bindRouteRelatedEvents('schedulers', appResources);
                    appRouter.showFilterLayout();
                    appRouter.showContentLayout();
                    appResources.getSchedulers().trigger('filterChanged', appResources.getSchedulers());

                    loader.hide();
                })
                .fail((err, name, description) => {
                    appRouter.showErrorPage(err, name, description);
                    error.fromXHR({ xhr: err, name, description });
                });
        })
        .fail((err, name, description) => {
            appRouter.showErrorPage(err, name, description);
            error.fromXHR({ xhr: err, name, description });
        });

    app.initMetric();
});
