const app = require('../app');
const error = require('../error');
const router = require('../router');
const loader = require('../views/loader');
// eslint-disable-next-line no-unused-vars
const Layout = require('../views/layouts/BasicLayout');
const LayoutConfig = require('../application/config/layoutConfig');
// eslint-disable-next-line no-unused-vars
const cookie = require('bemmy/src/blocks/component/cookie');
const resources = require('../resources');
// eslint-disable-next-line no-unused-vars
const BasicLayout = require('../collection/BasicCollection');
const rum = require('../helpers/utils/rum');

router.on('route:serviceNotifications', function () {
    /* eslint max-statements: [1, 14] */

    rum.setPage('service-notifications');

    app.performance.epoch = window.performance.now();
    app.performance.internalRoute = 'route:serviceNotifications';
    app.trigger('trigger:route:change', app.performance.internalRoute);

    document.title = ('Service notifications | Sandbox');

    this.unbindRouteRelatedEvents();

    loader.show();

    const appRouter = this;
    const resourceLocator = this.getResourceLocator();

    resourceLocator.setPageProps(LayoutConfig.getPageConfig('SERVICE_NOTIFICATIONS_LIST'));

    this.showBasicLayout();

    resources
        .serviceNotificationsList({
            user: {},
            notifications: {}
        }, this.getResourceLocator())
        .done(() => {
            appRouter.showContentLayout();

            loader.hide();
        })
        .fail((err, name, description) => {
            appRouter.showErrorPage(err, name, description);
            error.fromXHR({ xhr: err, name, description });
        });

    app.initMetric();
});
