// eslint-disable-next-line no-unused-vars
const Layout = require('../views/layouts/BasicLayout');
const LayoutConfig = require('../application/config/layoutConfig');
const app = require('../app');
const router = require('../router');
const loader = require('../views/loader');
const resources = require('../resources/index');
const error = require('../error');
const rum = require('../helpers/utils/rum');

router.on('route:statistics', function (type) {
    /* eslint max-statements: [1, 16] */

    rum.setPage('statistics');

    app.performance.epoch = window.performance.now();
    app.performance.internalRoute = 'route:statistics';
    app.trigger('trigger:route:change', app.performance.internalRoute);

    document.title = 'Statistics | Sandbox';

    this.unbindRouteRelatedEvents();

    type = type || 'tasks';

    const appRouter = this;
    const statPageConfig = {
        rest: {
            pageType: 'STAT_REST'
        },
        tasks: {
            pageType: 'STAT_TASKS'
        },
        xmlrpc: {
            pageType: 'STAT_XMLRPC'
        }
    };
    const resourceLocator = this.getResourceLocator();

    resourceLocator.setPageProps(LayoutConfig.getPageConfig(statPageConfig[type].pageType));

    this.showBasicLayout();
    loader.show();

    resources
        .statistics({}, this.getResourceLocator())
        .done(() => {
            appRouter.showContentLayout();

            loader.hide();
        })
        .fail((err, name, description) => {
            appRouter.showErrorPage(err, name, description);
            error.fromXHR({ xhr: err, name, description });
        });

    app.initMetric();
});
