const app = require('../app');
const error = require('../error');
const router = require('../router');
const loader = require('../views/loader');
const resources = require('../resources/index');
const rum = require('../helpers/utils/rum');

router.on('route:task', function (id, action) {
    /* eslint max-statements: [1, 15] */

    rum.setPage('task');

    app.performance.epoch = window.performance.now();
    app.performance.internalRoute = 'route:task';
    app.trigger('trigger:route:change', app.performance.internalRoute);

    document.title = ('Task view | Sandbox');

    this.unbindRouteRelatedEvents('task');
    this.showBasicLayout();

    loader.show();

    const appRouter = this;
    const resourceLocator = this.getResourceLocator();

    resourceLocator.setPageProps(appRouter.getLayoutConfig('SINGLE_TASK', {
        action: (action ? action : 'view')
    }));

    resources
        .task({ user: {}, task: { id }}, this.getResourceLocator())
        .done(appResources => {
            appRouter.bindRouteRelatedEvents('task', appResources);
            appRouter.showContentLayout();
            loader.hide();
        })
        .fail((err, name, description) => {
            appRouter.showErrorPage(err, name, description);
            error.fromXHR({ xhr: err, name, description });
        });

    app.initMetric();
});
