const ErrorView = require('./views/components/globalMessage/ErrorMessage');
const app = require('./app');
const error = {

    message(message, options) {
        const errorView = new ErrorView(_.extend({}, options, {
            message
        }));

        app.error.close();
        app.error.show(errorView);

        return errorView;
    },

    loadFail() {
        return error.message('Something went wrong');
    },

    fromXHR(e, options) {
        /* eslint max-statements: [1, 21] */
        /* eslint complexity: [1, 18] */

        options = typeof options === 'object' ? options : {};

        if (e.name === 'abort' || e.statusText === 'abort') {
            return;
        }

        let json = e.xhr ?
            e.xhr.responseJSON :
            e.responseJSON;
        const message = [];

        json = e && e.reason ? e : json;

        if (e.name || (e.description && e.description.message)) {
            message.push(e.name + (e.description && e.description.message ? ': ' + e.description.message : ''));
        }
        if (json) {
            if (json.reason) {
                const reason = json.reason
                    .replace('<', '&lt;')
                    .replace('>', '&gt;');

                message.push(reason);
            }
        } else {
            if (e.status === 500) {
                message.push('Internal server error');
            } else if (e.status === 403) {
                message.push('Access denied');
            } else if (e.status === 400) {
                message.push('Bad request');
            } else if (e.status === 0) {
                message.push('Please check internet connection');
            } else {
                message.push('Unhandled status: ' + e.status);
            }

            console.error(e); // eslint-disable-line
        }

        return error.message(message.join('; '), _.extend({ reload: false }, options));
    },

    close() {
        app.error.close();
    },

    instance() {
        return new ErrorInstance();
    },

    showErrPage(err) {
        const router = require('./router');

        app.reqres.request('ERR_XHR_OBJ', err);

        router.trigger('route:error');
    }
};

function ErrorInstance() {}

_.extend(ErrorInstance.prototype, {

    message(message, options) {
        this.errorView = error.message(message, options);
    },

    loadFail(e) {
        this.errorView = error.loadFail(e);
    },

    fromXHR(e) {
        this.errorView = error.fromXHR(e);
    },

    close() {
        if (this.errorView) {
            this.errorView.close();
            this.errorView = null;
        }
    }
});

module.exports = error;
