const app = require('../app.js');

app.reqres.setHandler('ERR_TRACE', errTrace => {
    if (_.isUndefined(errTrace)) {
        return app.getLastTrace();
    }
    let trace = (typeof errTrace === 'string' ? errTrace : '');

    if (errTrace && errTrace.traceback) {
        trace = errTrace.traceback;
    }

    if (errTrace && errTrace.responseJSON && errTrace.responseJSON.traceback) {
        trace = errTrace.responseJSON.traceback;
    }

    app.setLastTrace(trace);
});
