module.exports = {

    /**
     * @param {String|Moment} rawTime
     * @returns {Moment}
     */
    toLocal(rawTime) {
        return moment.utc(rawTime).local();
    },

    /**
     * @param {String|Moment} rawTime
     * @returns {Moment}
     */
    toUTC(rawTime) {
        return moment(rawTime);
    },

    serializeTimeMark(mark) {
        mark = mark.includes && mark.includes('Invalid') ? '' : mark;
        mark = moment(mark);

        const serialized = {
            time: '',
            date: '',
            comment: ''
        };

        return (mark.isValid() ? {
            time: mark.format('HH:mm:ss'),
            date: mark.format('DD.MM.YYYY'),
            comment: mark.fromNow()
        } : serialized);
    }
};
