const app = require('../../app');

const parseApiInfo = _.debounce(xhr => {
    app.vent.trigger(
        'API_INFO_CHANGED',
        xhr.getResponseHeader('x-backend-server'),
        xhr.getResponseHeader('x-tasks-revision')
    );
}, 100);

const parseModeInfo = _.debounce(xhr => {
    app.setAppMode(xhr.getResponseHeader('x-service-mode'));
    app.vent.trigger(
        'API_MODE_CHANGED',
        xhr.getResponseHeader('x-service-mode') || '',
        xhr.getResponseHeader('x-database-locked-by') || ''
    );
}, 100);

$(document).ajaxSuccess((evtObj, xhr) => {
    if (
        xhr.getResponseHeader('x-backend-server') &&
        xhr.getResponseHeader('x-tasks-revision')
    ) {
        parseApiInfo(xhr);
    }

    if (xhr.getResponseHeader('x-service-mode')) {
        parseModeInfo(xhr);
    }
});
