$.validateExtend({
    reg: {
        conditional(reg) {
            let result = true;

            try {
                new RegExp(reg); // eslint-disable-line
            } catch (excpt) {
                result = false;
            }

            return result;
        }
    },
    date: {
        required: false,
        pattern: /^[0-9]{2}\.[0-9]{2}\.[0-9]{4}$/,
        conditional(date) {
            let parts = date.split('.');
            let result = false;

            if (date === '') {
                result = true;
            } else {
                parts = parts.map(item => {
                    return parseInt(item, 10);
                });

                if (parts[0] > 0 &&
                    parts[0] < 32 &&
                    parts[1] > 0 &&
                    parts[1] < 13 &&
                    parts[2] > 1900 &&
                    parts[2] <= (new Date()).getFullYear()) {
                    result = true;
                }
            }

            return result;
        }
    },
    datetime: {
        required: false,
        pattern: /^[0-9]{2}\.[0-9]{2}\.[0-9]{4} [0-9]{2}:[0-9]{2}:[0-9]{2}$/,
        conditional(date) {
            let parts = date.split(':');
            let result = false;

            if (date === '') {
                result = true;
            } else {
                parts = parts.map(item => {
                    return parseInt(item, 10);
                });

                if (parts[0] >= 0 &&
                    parts[0] < 24 &&
                    parts[1] >= 0 &&
                    parts[1] < 60 &&
                    parts[2] >= 0 &&
                    parts[2] < 60) {
                    result = true;
                }
            }

            return result;
        }
    }/* ,
    timeToKill: {
        required: false,
        pattern: /[0-9]+[hms]/
    },
    space: {
        required: false,
        pattern: /[0-9]+((GB)|(KB)|(MB)|(TB))/
    } */
});
