const executor = require('./lazyExecutor');

const lazyDash = function (array) {
    const container = function (workload) {
        const reduce = function (callback, initial) {
            const promise = $.Deferred(); // eslint-disable-line

            workload.then(array => {
                let memo = initial;

                array.forEach((item, index) => {
                    executor.addTask(() => {
                        memo = callback(memo, item, index);
                    });
                });

                executor.addTask(() => {
                    promise.resolve(memo);
                });
            });

            return container(promise);
        };

        return {

            then(callback) {
                return workload.then(callback);
            },

            forEach(callback) {
                return reduce((memo, item, index) => {
                    callback(item, index);

                    memo.push(item);

                    return memo;
                }, []);
            },

            map(callback) {
                return reduce((memo, item, index) => {
                    memo.push(callback(item, index));

                    return memo;
                }, []);
            },

            filter(callback) {
                return reduce((memo, item, index) => {
                    if (callback(item, index)) {
                        memo.push(item);
                    }

                    return memo;
                }, []);
            },

            sortBy(getter) {
                const promise = $.Deferred(); // eslint-disable-line

                workload.then(array => {
                    promise.resolve(_.sortBy(array, getter));
                });

                return container(promise);
            }
        };
    };

    return container($.Deferred().resolve(array)); // eslint-disable-line
};

module.exports = lazyDash;
