const raf = window.requestAnimationFrame || window.setTimeout;

const Executor = function () {
    this.tasks = [];
};

Executor.prototype = {

    addTask(callback, context) {
        this.tasks.push({
            callback,
            context
        });

        this._start();
    },

    _start() {
        if (this._isStarted) {
            return;
        }

        this._isStarted = true;

        this._waitFrame();
    },

    _waitFrame() {
        raf(this._frame.bind(this));
    },

    _frame() {
        /* eslint max-statements: [1, 12] */

        const time = Date.now();
        let spent;

        while (this.tasks.length) {
            this._invokeTask(this.tasks.shift());

            spent = (Date.now() - time);

            if (spent > 10) {
                break;
            }
        }

        if (develop && spent > 50) {
            /* eslint no-console: 0 */
            console.warn('Some tasks were very slow. Spent %dms', spent);
        }

        if (this.tasks.length) {
            this._waitFrame();
        } else {
            this._isStarted = false;
        }
    },

    _invokeTask(task) {
        try {
            return task.callback.call(task.context);
        } catch (err) {
            raf(() => {
                throw err;
            });
        }
    }

};

module.exports = new Executor();
