module.exports = function (url, method) {
    return new Promise(((resolve, reject) => {
        method = method || 'GET';

        const xhr = new XMLHttpRequest();

        xhr.open(method, url);

        xhr.withCredentials = true;

        xhr.onload = function () {
            if (xhr.readyState === 4 && xhr.status >= 200 && xhr.status < 300) {
                resolve(xhr.response);
            } else {
                reject({ // eslint-disable-line
                    status: this.status,
                    statusText: xhr.statusText
                });
            }
        };

        xhr.onerror = function () {
            reject({ // eslint-disable-line
                status: this.status,
                statusText: xhr.statusText
            });
        };

        xhr.send();
    }));
};
