/* global Ya */

const cookie = require('bemmy/src/blocks/component/cookie');

const pages = {
    '/': '.3039',
    tasks: '.3039',
    task: '.3040',
    resources: '.3041',
    resource: '.3042',
    schedulers: '.3043',
    scheduler: '.3045',
    clients: '.3046',
    releases: '.3047',
    admin: '.3048',
    statistics: '.3049',
    oauth: '.3050',
    error: '.1030',
    notifications: '.3051',
    'service-notifications': '.188.3051',
    host: '.3052',
    preferences: '.3054',
    unknown: '.836'
};

module.exports = {
    pages,
    setPage: page => {
        if (Ya && Ya.Rum && Ya.Rum.enabled) {
            const loggedState = cookie.getYandexLogin() ? '.3055' : '.3056';
            const name = '28.3030' + loggedState + (pages[page] || pages.unknown);

            Ya.Rum.setVars({ 143: name });
        }
    }
};
