const InfoMessageView = require('./views/components/globalMessage/InfoMessage');
const app = require('./app');
const info = {

    message(message, options) {
        const infoView = new InfoMessageView(_.extend({}, options, {
            message
        }));

        app.info.close();
        app.info.show(infoView);

        return infoView;
    },

    close() {
        app.info.close();
    },

    instance() {
        return new InfoMessageInstance();
    }
};

function InfoMessageInstance() {}

_.extend(InfoMessageInstance.prototype, {

    message(message, options) {
        this.infoView = info.message(message, options);
    },

    close() {
        if (this.infoView) {
            this.infoView.close();
            this.infoView = null;
        }
    }

});

module.exports = info;
