/**
 * @class AuditModel
 * @extends Backbone.Model
 */
const AuditModel = Backbone.Model.extend({

    url() {
        const id = this.get('id');

        if (id) {
            return '/api/v1.0/semaphore/' + id + '/audit';
        }

        return false;
    },

    defaults: {
        source: '',
        description: '',
        author: '',
        target: '',
        time: ''
    }
});

module.exports = AuditModel;
