/**
 * @class AutocompleteItemModel
 * @extends Backbone.Model
 */
const AutocompleteItemModel = Backbone.Model.extend({

    defaults: {
        label: '',
        description: ''
    },

    isMatch(searchPhrase, anyLabel) {
        let result = false;
        const label = this.get('label');

        searchPhrase = searchPhrase.toLowerCase();

        if (label.toLowerCase().includes(searchPhrase) || this.get('description').includes(searchPhrase)) {
            result = true;
        }

        if (!result && typeof anyLabel !== 'undefined' && label === anyLabel) {
            result = true;
        }

        return result;
    }
});

module.exports = AutocompleteItemModel;
