const BasicFilterModel = require('./filter/BasicFilterModel');

/**
 * @description Represent last used filter state for a user. Will
 *
 * @class DefaultTaskListFilterState
 * @extends BasicFilterModel
 */
const DefaultTaskListFilterState = BasicFilterModel.extend({

    url: '/api/v1.0/user/current/preferences/task-list-last-filter',

    saveFilterState() {
        return $.ajax({
            url: this.url,
            type: 'PUT',
            data: JSON.stringify(this.toJSON()),
            dataType: 'json',
            contentType: 'application/json'
        });
    }
});

module.exports = DefaultTaskListFilterState;
