/**
 * @class ListModel
 * @extends Backbone.model
 */
module.exports = Backbone.Model.extend({

    defaults: {},

    /**
     * Override
     * Заставляем toJSON возвращать массив
     * @returns {*[]}
     */
    toJSON() {
        const json = _.clone(this.attributes);

        Object.keys(json).forEach(key => {
            if ((json[key] instanceof Backbone.Model) || (json[key] instanceof Backbone.Collection)) {
                json[key] = json[key].toJSON();
            }
        });

        return [json];
    }
});
