const MaillistSuggestGroupModel = require('./suggest/filter/MaillistSuggestGroupModel');
const UserGroupModel = require('./resources/UserGroupModel');
const UserModel = require('./user');

/**
 * @class NotificationModel
 * @extends Backbone.model
 */
const NotificationModel = Backbone.Model.extend({

    defaults() {
        return {
            statuses: [],
            transport: NotificationModel.TRANSPORT.EMAIL,
            recipients: []
        };
    },

    validateRecipients() {
        const self = this;
        const results = [];
        const isValid = $.Deferred(); // eslint-disable-line
        const recipients = this.get('recipients');

        recipients.forEach(recipient => {
            self.getRecipientValidateMethod(recipient)(recipient)
                .always(result => {
                    results.push(result);

                    if (results.length === recipients.length) {
                        const notValidItems = _.filter(results, result => {
                            return result.isValid === false;
                        });

                        if (notValidItems.length > 0) {
                            self.trigger('invalid:recipients', self, notValidItems);
                            self.trigger('invalid', self, notValidItems);

                            isValid.reject(notValidItems);
                        } else {
                            isValid.resolve(results);
                        }
                    }
                });
        });

        return isValid;
    },

    getRecipientValidateMethod(recipient) {
        if (recipient.includes('@')) {
            // Mailing list
            return MaillistSuggestGroupModel.validateMailingList;
        }
        if (recipient.toUpperCase() === recipient) {
            // User group
            return UserGroupModel.validateUserGroup;
        }
        // Single user
        return UserModel.validateUser;
    }

});

NotificationModel.TRANSPORT = {
    EMAIL: 'email',
    JABBER: 'jabber'
};

module.exports = NotificationModel;
