/**
 * QuickModel replaces Backbone.Model constructor to avoid calls of parse(),
 * merging properties with defaults and events triggering on create.
 *
 * @class QuickModel
 * @extends Backbone.Model
 */
const QuickModel = Backbone.Model.extend({

    constructor(attributes) {
        this.id = attributes.id;
        this.cid = _.uniqueId('c');
        this.attributes = attributes;
    },

    defaults: {
        id: null,
        cid: null,
        attributes: {}
    }
});

module.exports = QuickModel;
