/* eslint camelcase: 0 */

/**
 * @class ReleaseModel
 * @extends Backbone.Model
 */
const ReleaseModel = Backbone.Model.extend({

    url() {
        return ('/api/v1.0/release/' + this.get('id'));
    },

    defaults: {
        id: 0,
        type: '',
        state: '',
        author: '',
        message: '',
        task_id: '',
        created: '',
        subject: '',
        resources: []
    },

    idAttribute: 'task_id'
}, {
    getPossibleStatuses() {
        return Object.keys(ReleaseModel.STATE).map(key => {
            return ReleaseModel.STATE[key];
        });
    },

    STATE: {
        STABLE: 'stable',
        TESTING: 'testing',
        UNSTABLE: 'unstable',
        CANCELLED: 'cancelled',
        PRESTABLE: 'prestable'
    }
});

module.exports = ReleaseModel;
