/* eslint camelcase: 0 */

/**
 * @class ResourceModel
 * @extends Backbone.Model
 */
const ResourceModel = Backbone.Model.extend({

    url() {
        const base = 'https://proxy.sandbox.yandex-team.ru';

        // Var isPrestable = window.location.origin.indexOf('www-sandbox1.n') !== -1 ||
        //     window.location.origin.indexOf('localhost') !== -1;
        // var base = isPrestable ?
        //     'https://proxy-sandbox1.n.yandex-team.ru' :
        //     'https://proxy.sandbox.yandex-team.ru';

        return (base + '/upload/' + this.get('resourceType'));
    },

    defaults: {
        resourceType: '',
        owner: '',
        attrs: [],
        description: '',
        file: ''
    },

    validate() {
        /* eslint max-statements: [1, 16] */

        const attrs = this.attributes;
        const messages = [];
        let error = {};

        if (!$.trim(attrs.resourceType)) {
            error = {
                message: 'You should fill this field.',
                field: 'resourceType'
            };

            messages.push(error);

            this.trigger('invalid:resourceType', error);
        }

        if (!$.trim(attrs.owner)) {
            error = {
                message: 'You should fill this field.',
                field: 'owner'
            };

            messages.push(error);

            this.trigger('invalid:owner', error);
        }

        if (!$.trim(attrs.description)) {
            error = {
                message: 'You should fill this field.',
                field: 'description'
            };

            messages.push(error);

            this.trigger('invalid:description', error);
        }

        return messages;
    },

    toJSON() {
        const json = _.pick(_.clone(this.attributes), Object.keys(this.defaults));

        return json;
    }
});

module.exports = ResourceModel;
