/* eslint camelcase: 0 */

/**
 * @class SandboxNotificationModel
 * @extends Backbone.Model
 */
const SandboxNotificationModel = Backbone.Model.extend({

    url() {
        return ('/api/v1.0/notification/' + this.get('id'));
    },

    defaults: {
        id: 0,
        sent: true,
        type: '',
        host: '',
        body: '',
        view: '',
        author: '',
        charset: '',
        headers: [],
        subject: '',
        task_id: 0,
        created: '',
        selected: null,
        transport: '',
        recipients: [],
        inconsistent: true
    },

    initialize() {
        this.fetchAdditionalData = _.memoize(this.fetchAdditionalData);
    },

    serializeNotification() {
        const serialized = this.toJSON();

        serialized.transport = serialized.transport === 'email' ?
            'mail' :
            'msg';
        serialized.created = moment.utc(serialized.created).local().format('DD.MM [at] HH:mm');

        return serialized;
    },

    fetchAdditionalData() {
        return this.fetch({
            timeout: 3000
        });
    }
});

module.exports = SandboxNotificationModel;
