const app = require('../app');
const TaskModel = require('./TaskModel');

/**
 * @class SchedulerTaskModel
 * @extends TaskModel
 */
const SchedulerTaskModel = TaskModel.extend({

    /**
     * @description Will fetch task custom parameters from the server, but if it already fetched,
     *              will map same-named properties values to .context.value props.
     *
     * @param   {String}          mode
     * @returns {jQuery.Deferred}
     */
    fetchCustomParameters(mode) {
        const self = this;
        let customFields = this.get('customFields');

        if (customFields instanceof Array && (!mode || mode === this.get('customFieldsMode'))) {
            customFields = this.mapToCustomFields(customFields);
            this.set('customFields', customFields);

            return $.Deferred().resolve(customFields); // eslint-disable-line
        }

        return $.ajax({
            url: ('/api/v1.0/scheduler/' + this.getScheduler().get('id') + '/custom/fields'),
            type: 'GET',
            dataType: 'json',
            contentType: 'application/json'
        })
            .done(data => {
                self.set('customFields', data);
                self.set('customFieldsMode', mode);
            });
    },

    getScheduler() {
        return this.scheduler;
    },

    setScheduler(scheduler) {
        this.scheduler = scheduler;
    },

    setAsDraft() {
        app.setDraftScheduler(this.getScheduler());
    },

    getValidateURL() {
        return ('/api/v1.0/scheduler/' + this.getScheduler().get('id') + '/custom/fields');
    },

    /**
     * @param {Object} response
     * @param {Object} options
     *
     * @returns {Object|Null} Will return parsed object in all cases except when parsing is off
     *                        by setting options.parse to FALSE.
     */
    parse(response, options) {
        if (options && options.parse === false) {
            return null;
        }

        response = (typeof response === 'undefined' ? {} : response);

        return _.extend(
            {},
            TaskModel.PROP_SET,
            response,
            { notifications: this.parseNotifications(response.notifications) },
            { semaphores: this.parseSemaphores((response.requirements || {}).semaphores) },
            response.last ? { id: response.last.id, status: response.last.status } : {}
        );
    }
});

module.exports = SchedulerTaskModel;
