/* eslint camelcase: 0 */

/**
 * @class SemaphoreModel
 * @extends Backbone.Model
 */
const SemaphoreModel = Backbone.Model.extend({

    url() {
        const id = this.get('id');

        return ('/api/v1.0/semaphore' + (id ? '/' + id : ''));
    },

    defaults: {
        tasks: [],
        capacity: 0,
        name: '',
        rights: '',
        url: '',
        time: {},
        value: 0,
        ttl: 0,
        owner: '',
        shared: [],
        event: '',
        statistics_url: ''
    },

    save(attrs, options) {
        const whiteList = ['capacity', 'owner', 'shared', 'auto', 'event'];

        options = options || {};
        attrs = attrs || _.clone(this.attributes);

        if (this.attributes.id) {
            attrs = _.pick(attrs, whiteList);
        }

        options.data = JSON.stringify(attrs);

        return Backbone.Model.prototype.save.call(this, attrs, options);
    }
});

module.exports = SemaphoreModel;
