/**
 * @class ServiceNotificationModel
 * @extends Backbone.Model
 */
const ServiceNotificationModel = Backbone.Model.extend({

    constructor(attributes) {
        attributes = attributes || this.defaults();

        this.cid = _.uniqueId('c');
        this.attributes = attributes;
    },

    url() {
        return ('/api/v1.0/service/ui/notification' + (this.get('id') ? ('/' + this.get('id')) : ''));
    },

    defaults() {
        return {
            cid: _.uniqueId('c'),
            content: '',
            severity: ServiceNotificationModel.SEVERITY.INFO
        };
    }
}, {
    SEVERITY: {
        INFO: 'INFO',
        WARNING: 'WARNING',
        CRITICAL: 'CRITICAL'
    }
});

module.exports = ServiceNotificationModel;
