/**
 * @class ServiceNotificationPrefsModel
 * @extends Backbone.Model
 */
const ServiceNotificationPrefsModel = Backbone.Model.extend({

    url: '/api/v1.0/user/current/preferences/service-notifications',

    defaults: {
        id: 1,
        closedNotifications: []
    },

    addClosed(closedItemId) {
        this.get('closedNotifications').push(closedItemId);

        return this.save();
    },

    isClosed(idToTest) {
        return (this.get('closedNotifications').includes(idToTest));
    },

    isEmpty() {
        return (this.get('closedNotifications').length === 0);
    }

});

module.exports = ServiceNotificationPrefsModel;
