/**
 * @class TaskRequirementsSemaphoresModel
 * @extends Backbone.model
 */
const TaskRequirementsSemaphoresModel = Backbone.Model.extend({
    defaults() {
        return {
            release: [],
            weight: 0,
            capacity: 0,
            name: ''
        };
    },

    initialize(data) {
        data = data || {};

        this.set({
            release: data.release || [],
            weight: (data.semaphore && data.semaphore.weight) || 0,
            capacity: (data.semaphore && data.semaphore.capacity) || 0,
            name: (data.semaphore && data.semaphore.name) || ''
        });

        this.unset('semaphore');
    }
});

module.exports = TaskRequirementsSemaphoresModel;
