/* eslint camelcase: 0 */

/**
 * @class VaultModel
 * @extends Backbone.Model
 */
const VaultModel = Backbone.Model.extend({

    url() {
        const id = this.get('id');

        return ('/api/v1.0/vault' + (id ? '/' + id : ''));
    },

    defaults: {
        url: '',
        name: '',
        data: '',
        owner: '',
        rights: '',
        shared: null, // Mixed collection of users and user groups
        data_length: 0
    },

    toJSON() {
        const serialized = _.extend({}, this.attributes);

        if (serialized.shared instanceof Backbone.Collection) {
            serialized.shared = serialized.shared.map(share => {
                return share.get('name');
            });
        }

        return serialized;
    },

    parse(data) {
        if (this.attributes.id && _.isUndefined(data)) {
            return this.attributes;
        }

        data.shared = new Backbone.Collection(_.map(data.shared, share => {
            return { name: share };
        }));

        return data;
    }
});

module.exports = VaultModel;
