const router = require('../../router');
const BasicFilterModel = require('../filter/BasicFilterModel');

/**
 * @class ClientFilterModel
 * @extends Backbone.Model
 */
const ClientFilterModel = BasicFilterModel.extend({

    defaults: {
        normalFreeSpace: '',
        searchPhrase: '',
        platform: '',
        tags: '',
        alive: null,
        busy: null
    },

    initialize(data, options) {
        this.set(this.parse(data));
        this.options = _.extend({}, this.options, options);
    },

    parse(data) {
        let result = {};

        if (data && data.options) {
            result = Object.assign({}, data.options);

            if (result.busy) {
                if (result.busy === 'true') {
                    result.busy = true;
                }

                if (result.busy === 'false') {
                    result.busy = false;
                }
            }

            if (result.alive) {
                if (result.alive === 'true') {
                    result.alive = true;
                }

                if (result.alive === 'false') {
                    result.alive = false;
                }
            }
        }

        return result;
    },

    serializeAsQuery() {
        let serialized = BasicFilterModel.prototype.serializeAsQuery.apply(this, arguments);

        serialized = _.pick(serialized, ['tags', 'alive', 'busy', 'normalFreeSpace', 'searchPhrase', 'platform']);

        return router.buildQueryJson(serialized);
    }
});

module.exports = ClientFilterModel;
