/**
 * @class ClientsGroupModel
 * @extends Backbone.Model
 */
const ClientsGroupModel = Backbone.Model.extend({

    defaults: {
        title: 'Clients group',
        items: null,
        capacity: 0
    },

    options: {
        filterKey: '',
        filterValue: '',
        baseCollection: null
    },

    initialize(props, options) {
        this.options = _.extend({}, this.options, options);
        this.set('items', new Backbone.Collection());
    },

    setItems() {
        const self = this;
        let targetCollection = null;

        if (this.options.filterKey === '') {
            targetCollection = this.options.baseCollection;
        } else {
            targetCollection = new Backbone.VirtualCollection(this.options.baseCollection, {
                filter(client) {
                    return self.getFilterValue(client) === self.options.filterValue;
                }
            });
        }

        this.set('items', targetCollection);
        this.set('capacity', targetCollection.length);
    }

}, {
    getFilterValue(item, filterKey) {
        if (typeof filterKey === 'string') {
            return item.get(filterKey);
        }
        if (typeof filterKey === 'function') {
            return filterKey(item);
        }
        return '';
    }
});

module.exports = ClientsGroupModel;
