/* eslint camelcase: 0 */

/**
 * @class ClientModel
 * @extends Backbone.Model
 */
const ClientModel = Backbone.Model.extend({

    initialize(props, opts) {
        this.url = '/api/v1.0/suggest/client';

        if (opts.type) {
            this.url += ('?task_type=' + opts.type);
        }
    },

    getHosts() {
        return this.get('hosts');
    },

    getPlatforms() {
        return this.get('platforms');
    },

    getCpuModels() {
        return this.get('cpu_models');
    },

    parse(data) {
        data.hosts = data.hosts.sort();
        data.platforms = data.platforms.sort();
        data.cpu_models = data.cpu_models.sort();

        return data;
    }
}).cache({
    ttl: 300,
    jsonOnly: true
});

module.exports = ClientModel;
