/* eslint camelcase: 0 */

const BasicFilterModel = require('./BasicFilterModel');

/**
 * @description Filter model for the releases' lists (resources page and modal window on the task create/edit page).
 *              And it's presets.
 *
 * @class ReleaseFilterModel
 * @extends BasicFilterModel
 */
const ReleaseFilterModel = BasicFilterModel.extend({

    filterItemName: 'release',

    url: '/api/v1.0/user/current/preferences/release-list-last-filter',

    defaults: {
        type: '',
        resource_type: ''
    },

    dropSelfAttrs(instance) {
        delete instance.title;
        delete instance.order;
        delete instance.found;
    },

    setDefaults() {
        this.set(ReleaseFilterModel.prototype.defaults);
        this.trigger('blank');
    }

}, {

    hasFilterValues(hashToCheck) {
        return BasicFilterModel.hasFilterValues(ReleaseFilterModel.getDefaults(), hashToCheck);
    },

    getDefaults() {
        return {
            type: '',
            resource_type: ''
        };
    }
});

module.exports = ReleaseFilterModel;
