/* eslint camelcase: 0 */

const BasicFilterModel = require('./BasicFilterModel');
const SchedulerFilterModel = require('./SchedulerFilterModel');

/**
 * @description Filter model for the tasks lists. And it's presets.
 *
 * @class SandboxNotificationFilterModel
 * @extends SchedulerFilterModel
 *
 * @property {String} filterItemName - Need to build preset capacity fetch URL
 * @property {String} url - Defined to match the last saved state of the filter for the tasks list
 */
const SandboxNotificationFilterModel = SchedulerFilterModel.extend({

    filterItemName: 'sandboxNotification',

    url: '/api/v1.0/user/current/preferences/sandbox-notifications-list-last-filter',

    defaults() {
        return _.extend(
            {},
            BasicFilterModel.prototype.defaults,
            SandboxNotificationFilterModel.getDefaults()
        );
    },

    setDefaults() {
        this.set(SandboxNotificationFilterModel.getDefaults());
        this.trigger('blank');
    }
}, {

    parseOuterFilterValues(outerValues) {
        const parsed = {};

        Object.keys(SandboxNotificationFilterModel.getDefaults()).forEach(key => {
            if (typeof outerValues[key] !== 'undefined') {
                const value = outerValues[key];

                parsed[key] = value;
            }
        });

        return parsed;
    },

    hasFilterValues(hashToCheck) {
        return BasicFilterModel.hasFilterValues(SandboxNotificationFilterModel.getDefaults(), hashToCheck);
    },

    getDefaults() {
        return {
            id: '',
            sent: true,
            author: '',
            created: '',
            task_id: '',
            transport: 'email',
            recipient: ''
        };
    }
});

module.exports = SandboxNotificationFilterModel;
