/* eslint camelcase: 0 */

const router = require('../../router');
const BasicFilterModel = require('./BasicFilterModel');

/**
 * @description Filter model for the tasks lists. And it's presets.
 *
 * @class SchedulerFilterModel
 * @extends BasicFilterModel
 *
 * @property {String} filterItemName - Need to build preset capacity fetch URL
 * @property {String} url - Defined to match the last saved state of the filter for the tasks list
 */
const SchedulerFilterModel = BasicFilterModel.extend({

    filterItemName: 'scheduler',

    url: '/api/v1.0/user/current/preferences/scheduler-list-last-filter',

    defaults() {
        return _.extend(
            {},
            BasicFilterModel.prototype.defaults,
            SchedulerFilterModel.getDefaults()
        );
    },

    idAttribute: '__id',

    options: {},

    initialize(data, options) {
        this.set(this.parse(data));
        this.options = _.extend({}, this.options, options);
    },

    /**
     * @override
     */
    getFilterParams() {
        const filterParams = this.toJSON();
        const filtered = {};

        this.dropSelfAttrs(filterParams);

        Object.keys(filterParams).forEach(key => {
            filtered[key] = filterParams[key];
        });

        return filtered;
    },

    setDefaults() {
        this.set(SchedulerFilterModel.getDefaults());
        this.trigger('blank');
    },

    serializeAsQuery() {
        const serialized = BasicFilterModel.prototype.serializeAsUrl.apply(this, arguments);

        if (serialized.tags instanceof Array) {
            serialized.tags = (serialized.tags.length > 0 ? serialized.tags.join(',') : '');
        }

        return router.buildQueryJson(serialized);
    },

    serializeAsUrl() {
        const serialized = BasicFilterModel.prototype.serializeAsUrl.apply(this, arguments);

        if (serialized.tags instanceof Array) {
            serialized.tags = (serialized.tags.length > 0 ? serialized.tags.join(',') : '');
        }

        return router.buildQueryJson(serialized);
    }
}, {
    parseOuterFilterValues(outerValues) {
        const parsed = {};

        Object.keys(SchedulerFilterModel.getDefaults()).forEach(key => {
            if (typeof outerValues[key] !== 'undefined') {
                let value = outerValues[key];

                if (key === 'status') {
                    value = value.toUpperCase();
                }

                parsed[key] = value;
            }
        });

        return parsed;
    },

    hasFilterValues(hashToCheck) {
        return BasicFilterModel.hasFilterValues(SchedulerFilterModel.getDefaults(), hashToCheck);
    },

    getDefaults() {
        return {
            id: '',
            owner: '',
            author: '',
            status: '',
            task_type: '',
            tags: [],
            all_tags: false
        };
    }
});

module.exports = SchedulerFilterModel;
