/* eslint camelcase: 0 */
const BasicFilterModel = require('./BasicFilterModel');

/**
 * @description Filter model for semaphores' lists.
 *              And it's presets.
 *
 * @class SemaphoreFilterModel
 * @extends BasicFilterModel
 */
const SemaphoreFilterModel = BasicFilterModel.extend({

    filterItemName: 'semaphore',

    url: '/api/v1.0/user/current/preferences/semaphore-list-last-filter',

    defaults() {
        return _.clone(SemaphoreFilterModel.getDefaults());
    },

    dropSelfAttrs(instance) {
        delete instance.name;
        delete instance.order;
        delete instance.shared;
    },

    resetFilter() {
        this.set(SemaphoreFilterModel.getDefaults());
    },

    setDefaults() {
        this.set(SemaphoreFilterModel.prototype.defaults);
        this.trigger('blank');
    }
}, {

    hasFilterValues(hashToCheck) {
        return BasicFilterModel.hasFilterValues(SemaphoreFilterModel.getDefaults(), hashToCheck);
    },

    getDefaults() {
        return {
            name: '',
            owner: '',
            shared: '',
            auto: undefined
        };
    }
});

module.exports = SemaphoreFilterModel;
