const BasicFilterModel = require('./BasicFilterModel');

/**
 * @description Filter model for the task type list.
 *
 * @class TaskTypeFilterModel
 * @extends BasicFilterModel
 */
const TaskTypeFilterModel = BasicFilterModel.extend({

    url: '/api/v1.0/user/current/preferences/tasktype-list-last-filter',

    defaults: {
        type: '',
        owner: ''
    },

    setDefaults() {
        this.set(TaskTypeFilterModel.prototype.defaults);
        this.trigger('blank');
    }
});

module.exports = TaskTypeFilterModel;
