/* eslint camelcase: 0 */

const Timer = require('../../helpers/utils/Timer');

/**
 * @class ServiceThreadModel
 * @extends Backbone.Model
 */
const ServiceThreadModel = Backbone.Model.extend({

    defaults: {
        id: '',
        last_run: '',
        next_run: '',
        lock_handlers: []
    },

    getNextRunInSeconds() {
        return parseInt(moment().diff(Timer.toLocal(this.get('next_run'))) / 1000, 10);
    },

    getNextRunInfo() {
        const nextRunInMs = this.getNextRunInSeconds();
        let state = '';

        if (nextRunInMs > 300) {
            state = ServiceThreadModel.NEXT_RUN_STATE.CRITICAL;
        } else if (nextRunInMs > 0) {
            state = ServiceThreadModel.NEXT_RUN_STATE.WARNING;
        } else {
            state = ServiceThreadModel.NEXT_RUN_STATE.NORMAL;
        }

        return {
            seconds: nextRunInMs,
            state
        };
    }

}, {
    NEXT_RUN_STATE: {
        NORMAL: 'normal',
        WARNING: 'warning',
        CRITICAL: 'critical'
    }
});

module.exports = ServiceThreadModel;
