const ShardServersCollection = require('../../collection/ShardServersCollection');

/**
 * @class ShardModel
 * @extends Backbone.Model
 *
 * @property {ShardServersCollection} replicaset
 */
const ShardModel = Backbone.Model.extend({

    defaults: {
        updated: '',
        replicaset: null,
        id: ''
    },

    idAttribute: 'id',

    parse(data) {
        const replicaset = new Array(6);

        data.replicaset.forEach(replica => {
            const id = replica.id.replace(/\.search\.yandex\.net:[0-9]+$/, '');

            replicaset[this.collection.keys.indexOf(id)] = replica;
        });

        return {
            updated: data.updated,
            replicaset: new ShardServersCollection(replicaset),
            id: data.id
        };
    }
}, {

    getShardServerIndex(srvName) {
        return parseInt(srvName.match(/([0-9]{2})\.search/i)[1], 10);
    }
});

module.exports = ShardModel;
